---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
aliases:
  - Chain
---

# Path (chain) (pattern)

> Single-route propagation along a sequence of interfaces.

---

## Definition

- Linear sequence of connected interfaces
- Single route for difference propagation
- Each hop must maintain signal integrity

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Path integrity | Link chain | `Monitor`, `Path` |
| Signal flow | Data stream | `Check`, `Flow` |
| Hop sequence | Route nodes | `Trace`, `Hop` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Path integrity | Connection line | "Clear channel" |
| Signal flow | Message flow | "Gets through" |
| Hop sequence | Steps forward | "Step by step" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Link chain | Connection line | How path forms |
| Data stream | Message flow | How signal moves |
| Route nodes | Steps forward | How path builds |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Wave guide | Energy flow |
| Networks | Packet route | Message path |
| Cognition | Neural path | Thought chain |
| Systems | Process flow | Action sequence |

---

## Scale Effects

How Path pattern manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Signal threshold | Quantum path |
| λV | Gate sequence | State chain |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Path coherence | Memory chain |
| ∇S | Path clarity | Clear steps |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Path limit | Light path |
| λV | Field chain | Space link |

Note: At extreme scales, path behavior faces fundamental limits (e.g., quantum tunneling at ε, causal chains at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: signal > threshold per hop
- c: latency within limits
- ψA: path spans interval
- λV: gates maintain flow

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Path definition | Step clarity |
| Human | λV | Gate sequence | Flow control |
| Cosmic | ψA | Path coherence | Chain binding |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Signal loss | Below threshold | Lost trace |
| Human | Path break | Link failure | Broken chain |
| Cosmic | Limit breach | Causal break | Lost connection |

---

## Diagnostic Checklist

Technical tests:
- [ ] Per-hop ε/λV satisfied
- [ ] End-to-end ψA window adequate
- [ ] No segment exceeds c
- [ ] Signal integrity maintained

Humane tests:
- [ ] Path feels continuous
- [ ] Steps are clear
- [ ] Flow is smooth
- [ ] Connection holds

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical routing nor experiential connection alone captures its full meaning.

---

## See Also

- [[Multi-path (redundant) (pattern)]]
- [[Cycle (feedback loop) (pattern)]]
- [[Cascade (pattern)]]
- [[Bridge / Articulation (pattern)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented